% Fuzzy C- Means (FCM) algorithm %
% The traditional FCM algorithm proposed by Bezdek is an improvement of earlier clustering methods (Bezdek, 1981). 
% FCM is based on minimizing an objective function, with respect to fuzzy membership U, and a set of cluster centroids V:

% Note that this program will take approximately 5-6 minutes to execute.
                                                  
%--------------------------------------------------------------------------
% The FCM consists of the following steps
%  1. Choose primary cluster centers .This can be done randomly, or initial estimates might   
 %    be chosen by examining the histogram of the image.
 % 2. Compute the degree of membership of each data point to all the clusters.
 % 3. Compute new cluster centers   according to equation  below
 %-------------------------------------------------------------------------

 
 % The followng matlab functions are used.
 % rgb2gray , size, imshow,
 %-------------------------------------------------------------------------%
clear;
image = imread('C:\Documents and Settings\mamta naik\Desktop\brain_mri_transversal_t1_002.jpg');                                                      % Load image for clustering %
image = rgb2gray(image);                                                           % Conversion of RGB image to Gray scale image %
image = double(image);                                                             % Conversion to double array for (program) calculation purpose %
[xsize,ysize] = size(image);                                                       % Decide dimesion of image %


cluster=4;                                                                         % Decide number of clusters to be separated; Skull,White matter,Gray matter,CSF %

V(1) = 25;
V(2) = 65;                                                                         % Initialise cluster centers by looking at Histogram of the image % 
V(3) = 120;
V(4) = 165;

counter = 0;                                                                       % Initialise the counter for number of iterations to be carried out %
unew = zeros(xsize,ysize,cluster);
Unew = zeros(xsize,ysize,cluster);                                                 % Initialise new fuzzy values for calculation %

while counter < 20;                                                                % Decide number of iterations by setting a limit for counter %
    
    
    U = 0;
    d = 0;
    Uij = zeros(1,cluster);                                                        % Initialise variables % 
    clustersize(1,cluster)= zeros;
    newcluster = zeros(xsize,ysize,cluster);
    csize(1:cluster) = 0;
    
    for loop1 = 1:xsize
        for loop2 = 1:ysize
            for count = 1:cluster
                if image(loop1,loop2) == V(count)
                    dn = 1;                                                      % d^2n means distance square(numerator) for Uij calculation % % Here check for 0 in denominator condition%
                else
                    dn = 1/(abs(image(loop1,loop2) - V(count)));                 % Distance between vector and cluster center %
                end
                for newloop = 1:cluster
                    if image(loop1,loop2) == V(newloop)                            % Here check for 0 in denominator condition %  
                        d = 1;
                    else
                        d = d + 1/(abs(image(loop1,loop2) - V(newloop)));      % Dist between vector and all cluster centers summation %
                    end
                end
                u(loop1,loop2,count) = dn/d;                                   % Computation of fuzziness for all vectors to each cluster centre %
                d = 0;
             end
             d = 0;
           
%-------------------------------------------------------------------------%         
             for loop3 = 1:cluster
                 Uij(loop3) = Uij(loop3) + u(loop1,loop2,loop3)^2;                 % Fuzzy memebership sum for new cluster (updated) %  
             end
             
             for cloop = 1:cluster                                                 % Division of pixels based on there fuzzy membership to clusters % 
                if u(loop1,loop2,cloop) == max(u(loop1,loop2,:)) 
                    newcluster(loop1,loop2,cloop) = 50;
                    csize(cloop) = csize(cloop) + 1;                               % Computation of cluster size %
                end  
            end    
            
        end
    end
    
    store = zeros(1,cluster);                                                        % Initialise variables %
    
    %---------------------------------------------------------------------%
                                                                                   % Computation of weighted fuzzy sum = (fuzzy sum * image pixel values) %
    for looper1 = 1:cluster                         
        for looper2 = 1:xsize
            for looper3 = 1:ysize
                store(looper1) = store(looper1) + (u(looper2,looper3,looper1)^2 * image(looper2,looper3));  % Decision of new cluster centers %
            end
        end
    end
    
    % ------------- Computation of new (updated) cluster centroids --------%
    
    for loop5 = 1:cluster
        V(loop5) = store(loop5)/ Uij(loop5)                                         % Updation of cluster centers
    end 
    
    %-- Termination criaterion for necessity of running another iteration -%
    
    if abs(unew - u) < 0.01                                                       % Necessity of another iteration ? %  
    else
        unew  = u;
    end
    
    counter = counter+1;
end
    
%--------- Final clusters -------------------------------------------------%

for final = 1:cluster
    figure
    imshow(newcluster(:,:,final))
end

    
    